/*
	$DOCFILE:CAPIOLD.C

	Copyright (C) 1999 Datalight, Inc.
	All Rights Reserved

	Almost same as capitest.c, only uses old capi.h
	This sample is included to show users of Sockets 1.0
	how to quickly port to the new CAPI.C and CAPI.H by including
	CAPIOLD.H in old programs.

	test for CAPI C function library
	Compile and link with CAPI.C
	Use TABS=3 spaces for properly formatted source

	Does not work properly with BorlandC unless LARGE memory model is used.
	This is caused by DS != SS in ServerHandler(). Int86x() which is called in
	CAPI.H assumes DS == SS for the SMALL model (which is normally a valid
	assumption). Not tested with Microsoft C. One way of solving the problem
	is to switch stacks to a stack in the data area - more assembler calls!


	$DOCHISTORY:
	06/29/1999 jmb added copyright header
	1.01 1999-03-18 Supports both Borland and Microsoft compilers
	2.00 1999-04-23 Version with built-in server
	2.01 1999-04-29 Fix parameters to set_opt()
	2.02 1999-05-31 Implemented solid code guidelines
/*

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <process.h>
#include "capi.h"
#include "capitest.pt"

//next 2 lines if you use old c api and its structure definitions
#define API_STRUCT_DEFS
#include "capiold.h"

#define KEY_MAX 10
#define DISP_MAX 500
#define CONNECTIONS	20		// number of server connections allowed

char rgcKeyBuf[KEY_MAX];	//for storing keys typed by user
int iKeyCnt;
char rgcDispBuf[DISP_MAX]; //used for reading data from server
int iDispCnt;

int iClientSock, iServerSock;
NET_ADDR sClientAddr, sServerAddr;
int rgiServerSocks[CONNECTIONS]; //all the connections made to this server

int iTelnetState;				// telnet state

//these variables are set at interrupt time
volatile int iEventPosted, iEventError;    //client callback related
volatile int iServEventPosted, iServEventError, iServError;//server callback related

int main(int argc, char *argv[])
{
	unsigned uCh;
	int i;
	char cClosed = 0, cUrgent = 0;
	DWORD dwClientAddr;
	char *pszArgvl[2];	//used in spawing COMSPEC

	printf("Sockets compatibility API test program(old)\n");
	printf("Copyright (C) 1999 Datalight, Inc.\nAll Rights Reserved\n\n");

	uCh = DISP_MAX;
	get_kernel_info(0, KInfHostname, 0, rgcDispBuf, &uCh);
	printf("API test version 2.00 on '%s'\n", rgcDispBuf);
	if (argc > 1)
	{
		if ((sClientAddr.remote_host = nm_res_name(argv[1],rgcDispBuf,DISP_MAX)) == 0)
		{
			printf("Error on nm_res_name: %s\n",GetErrorString(neterrno));
		}
	}
	else
	{
		printf("APITEST <server_name> [[<server_port>] <listen_port>]\n");
		exit(1);
	}
	sClientAddr.remote_port = (argc > 2) ? atoi(argv[2]) : 23;
	sServerAddr.local_port = (argc > 3) ? atoi(argv[3]) : 23;
	if ((i = StartListen()) < 0)
		printf("Error %d on StartListen: %s\n",i,GetErrorString(neterrno));
	printf("Trying to connect to %s %u.%u.%u.%u:%u\n",rgcDispBuf,
			((BYTE *)&sClientAddr.remote_host)[0],
			((BYTE *)&sClientAddr.remote_host)[1],
			((BYTE *)&sClientAddr.remote_host)[2],
			((BYTE *)&sClientAddr.remote_host)[3],sClientAddr.remote_port);
	if ((iClientSock = net_getglobdesc()) < 0)
	{
		printf("Error on net_getglobdesc: %s\n",GetErrorString(neterrno));
		exit(1);
	}
	InitTelnet();
	// make iClientSock non-blocking
	if (set_option(iClientSock,0,NetOptNonBlocking,1,1) < 0)
		printf("Error on set_option(): %s\n",GetErrorString(neterrno));

	if (net_connect(iClientSock,Stream,&sClientAddr) < 0)
	{
		printf("Error on net_connect: %s\n",GetErrorString(neterrno));
		exit(1);
	}
	// set ASYNC Handler on OPEN
	if (net_asynch(iClientSock,NetAsOpen,Handler,0) == (int far *)-1)
		printf("Error on net_async(Open): %s\n",GetErrorString(neterrno));
	// set ASYNC Handler on CLOSE
	if (net_asynch(iClientSock,NetAsClose,Handler,0) == (int far *)-1)
		printf("Error on net_async(Close): %s\n",GetErrorString(neterrno));
	// set ASYNC Handler on ERROR
	if (net_asynch(iClientSock,NetAsError,Handler,0) == (int far *)-1)
		printf("Error on net_async(Error): %s\n",GetErrorString(neterrno));
	while (!iEventPosted)
	{
		if (kbhit())
		{
			getch();
			break;
		}
	}
	switch (iEventPosted)
	{
	case NetAsError:
		printf("net_connect error %d\n",iEventError);
		break;
	case NetAsClose:
		printf("net_connect() closed\n");
		break;
	case NetAsOpen:
		printf("Connection established\n");
		break;
	default:
		printf("Unexpected event %d\n",iEventPosted);
		break;
	}
	if ((dwClientAddr = get_addr(iClientSock)) == 0)
		printf("Error on get_addr: %s\n",GetErrorString(neterrno));
	printf("get_addr returned %u.%u.%u.%u\n",
			((BYTE *)&dwClientAddr)[0],
			((BYTE *)&dwClientAddr)[1],
			((BYTE *)&dwClientAddr)[2],
			((BYTE *)&dwClientAddr)[3]);
	while (1)
	{
#ifdef DEBUG_SERVER
		if (iServEventPosted)
		{
			printf("Server event %d event error %d error %s\n",
			iServEventPosted,iServEventError,GetErrorString(iServError));
			iServEventPosted = 0;
			iServError = 0;
		}
#endif
		if (kbhit())
		{
			uCh = getch();
			if (uCh == 0)
			{			/* function key */
				switch (getch())
				{
				case 44:		/* alt Z */
					return 0;
				case 45:		/* alt X */
					goto exit;
				case 19:	/* alt R */
					if (net_release(iClientSock) < 0)
						printf("Error on net_release: %s\n",GetErrorString(neterrno));
					break;
				case 30:	/* alt A */
					if (net_abort(iClientSock) < 0)
						printf("Error on net_abort: %s\n",GetErrorString(neterrno));
					break;
				case 46:	/* alt C */
					if (net_eof(iClientSock) < 0)
						printf("Error on net_eof: %s\n",GetErrorString(neterrno));
					break;
				case 31:	/* alt S */
					Status(iClientSock);
					break;
				case 22:	/* alt u */
					printf("Urgent %s\n",(cUrgent ^= 1) ?
							"on" : "off");
					break;
				case 35:
					printf( "\n"
						"Alt-A	Abort\n"
						"Alt-C	Close\n"
						"Alt-E	Execute command.com\n"
						"Alt-F	Force read\n"
						"Alt-H	Help\n"
						"Alt-R	Release\n"
						"Alt-S	Status\n"
						"Alt-U	Urgent toggle\n"
						"Alt-X	eXit\n");
					break;
				case 18:	// alt e
					if ((pszArgvl[0] = getenv("COMSPEC")) == 0)
						pszArgvl[0] = "\\COMMAND.COM";
					pszArgvl[1] = 0;
					spawnvp(P_WAIT, pszArgvl[0], pszArgvl);
					break;
				case 33:	/* alt F */
					goto force_read;
				}
			}
			else if (iKeyCnt < KEY_MAX)
				rgcKeyBuf[iKeyCnt++] = uCh;
			else
				putchar(7);
		}
		if (iKeyCnt)
		{
			SendData(rgcKeyBuf,iKeyCnt);
			iKeyCnt = 0;
		}
		if (cClosed)
		{
			continue;
		}
		force_read:
		if ((iDispCnt = net_read(iClientSock,rgcDispBuf,DISP_MAX,&sClientAddr,NetFlgNonBlocking)) < 0)
		{
			if (neterrno == ErrWouldBlock)
				continue;	/* nothing to read */
			printf("Error on net_read: %s\n",GetErrorString(neterrno));
			if (neterrno == ErrEOF)
			{
				printf("Connection closed by remote host\n");
			}
			cClosed = 1;
			continue;
		}
		if (iDispCnt != 0)
			iDispCnt = TeloptStrip(rgcDispBuf, iDispCnt);
		for (i = 0; i < iDispCnt; ++i)
		{
			putchar(rgcDispBuf[i]);
		}
	}
	exit:
	net_release(iClientSock);
	for (i = 0;i < CONNECTIONS;++i)
	{
		if (rgiServerSocks[i])
			net_release(rgiServerSocks[i]);
	}
	net_release(iServerSock);
	return 0;
}

/*
Send bytes on iClientSock. Returns immediately (non blocking).
If an error occurs, the error message is printed to std out.

Arguments:
	pcBuf - pointer to buffer containing characters to be send.
	iCnt - Number of bytes to send.
*/
void SendData(char *pcBuf,int iCnt)
{
	if (net_write(iClientSock, pcBuf, iCnt, NetFlgNonBlocking) < 0)
		printf("Error on NetWrite: %s\n",GetErrorString(neterrno));
}

/*
Writes the status of specified socket to std out.

Arguments:
	iSock - The socket whose status will be displayed.

*/
void Status(int iSock)
{
	NET_ADDR sAddr;
	long lInFlags,lOutFlags;	//double words to receive information in api call

	lInFlags = lOutFlags = 0;
	if (net_select(31, &lInFlags, &lOutFlags) < 0)
		printf("Error on net_select %s\n",GetErrorString(neterrno));
	printf("\nI/O %08lX %08lX\n", lInFlags, lOutFlags);
	if (get_peer(iSock, &sAddr) < 0)
	{
		printf("Error on get_peer: %s\n",GetErrorString(neterrno));
	}
	else
	{
		printf("ND: %u remote_socket: %u.%u.%u.%u:%u local_port: %u Prot: %u\n",
			iSock,
			((BYTE *)&sAddr.remote_host)[0],
			((BYTE *)&sAddr.remote_host)[1],
			((BYTE *)&sAddr.remote_host)[2],
			((BYTE *)&sAddr.remote_host)[3],
			sAddr.remote_port,sAddr.local_port,sAddr.protocol);
	}
}

/*
 Async notification Handler for client socket - called by Sockets.
 Do NOT use any functions making DOS calls, eg printf().
 */

int _loadds far Handler(void)
{
	//only set flag, will be handled in main() function loop
	__asm	{
		mov iEventPosted, cx;
		mov iEventError, dx;
	}
	return 0;
}


// Async notification Handler for server - called by Sockets.
// Do NOT use any functions making DOS calls, eg printf().
// Do NOT use local variables as the base pointer will get confused
//(you may use local vars in functions called from this one however)

int _loadds far ServerHandler(void)
{
	static char rgcBuf[200];
	static int iServSock, iIndex;
	static int iSavedSS, iSavedSP;	//save stack segment and -pointer to perform rgcStack-switch
	static char rgcStack[200];			//the new stack
	static int iStackPointer;			//pointer to new stack

	iStackPointer = (int)rgcStack + 200;
	__asm {
		mov 	iServSock, bx;
		mov 	iServEventPosted, cx;
		mov	iServEventError, dx;
		mov	iSavedSS, ss;
		mov	iSavedSP, sp;
		mov	ax, ds;
		mov	ss, ax;
		mov   sp, iStackPointer;
	}

	switch (iServEventPosted)
	{
	case NET_AS_ERROR:
	case NET_AS_CLOSE:
		for (iIndex = 0; iIndex < CONNECTIONS; ++iIndex)
		{
			if (rgiServerSocks[iIndex] == iServSock)
			{
				rgiServerSocks[iIndex] = 0;
				break;
			}
		}
		break;
	case NET_AS_OPEN:
		for (iIndex = 0;iIndex < CONNECTIONS;++iIndex)
		{
			if (rgiServerSocks[iIndex] == 0)
			{
				rgiServerSocks[iIndex] = iServSock;
				iNetErrNo = 0;
				if (StartListen() < 0)
					iServError = iNetErrNo;
				break;
			}
		}
		if (iIndex == CONNECTIONS)
		{
			ReleaseSocket(iServSock);
			break;
		}
		iNetErrNo = 0;
		if (WriteSocket(iServSock, "CAPITEST server ready\r\n", 23, 0) < 0)
			iServError = iNetErrNo;
		break;
	case NET_AS_FCLOSE:		// peer closed connection
	case NET_AS_RCV:
		iNetErrNo = 0;
		//only echo data back
		if ((iIndex = ReadSocket(iServSock, rgcBuf, sizeof(rgcBuf), 0, 0)) > 0)
			iServError = WriteSocket(iServSock, rgcBuf, iIndex, 0);
		else
			iServError = iNetErrNo;
		if (iServEventPosted == NET_AS_FCLOSE)
			if (EofSocket(iServSock) < 0)
				iServError = iNetErrNo;
		break;
	case NET_AS_XMT:
		break;
	}
	__asm {
		mov	ss, iSavedSS;
		mov	sp, iSavedSP;
	}
	return 0;
}

/*
Start a server socket listening on the port number contained in the
sServerAddr structure.
Set all the api callbacks concerning this socket to ServerHandler.

Returns:
	The newly created server socket.
*/
int StartListen(void)
{
	int retv = 0;

	if ((iServerSock = net_getglobdesc()) < 0)
	{
		return -1;
	}
	// make iServerSock non-blocking
	if (set_option(iServerSock,0,NetOptNonBlocking,1,1) < 0)
		return -2;

	if (net_listen(iServerSock,Stream,&sServerAddr) < 0)
	{
		return -3;
	}
	// set ASYNC Handler on OPEN
	if (net_asynch(iServerSock,NetAsOpen,ServerHandler,0) == (int far *)-1)
		retv = -4;
	// set ASYNC Handler on CLOSE
	if (net_asynch(iServerSock,NetAsClose,ServerHandler,0) == (int far *)-1)
		retv = -5;
	// set ASYNC Handler on FCLOSE
	if (net_asynch(iServerSock,NetAsFclose,ServerHandler,0) == (int far *)-1)
		retv = -6;
	// set ASYNC Handler on ERROR
	if (net_asynch(iServerSock,NetAsError,ServerHandler,0) == (int far *)-1)
		retv = -7;
	// set ASYNC Handler on RECEIVE
	if (net_asynch(iServerSock,NetAsRcv,ServerHandler,0) == (int far *)-1)
		retv = -8;
	// set ASYNC Handler on XMIT
	if (net_asynch(iServerSock,NetAsXmt,ServerHandler,0) == (int far *)-1)
		retv = -9;
	return retv;
}

/*
Create a human understandable string from a Sockets error code.

Argument:
	uErrCode - The sockets error code.

Returns:
	A pointer to the (static) string representation of the error.
*/
char *GetErrorString(unsigned uErrCode)
{
	static char rgcUnk[30];
	static char *rgszErrs[] =
	{
		"NoErr",
		"InUse",
		"DOSErr",
		"NoMem",
		"NotNetconn",
		"IllegalOp",
		"BadPkt",
		"NoHost",
		"CantOpen",
		"NetUnreachable",
		"HostUnreachable",
		"ProtUnreachable",
		"PortUnreachable",
		"TimeOut",
		"HostUnknown",
		"NoServers",
		"ServerErr",
		"BadFormat",
		"BadArg",
		"EOF",
		"Reset",
		"WouldBlock",
		"UnBound",
		"NoDesc",
		"BadSysCall",
		"CantBroadcast",
		"NotEstab",
		"ReEntry",
	};

	if (uErrCode == ERR_API_NOT_LOADED)
		return "Rinet API not loaded";
	if ((uErrCode & 0xff) > ERR_RE_ENTRY)
	{
		sprintf(rgcUnk,"Unknown error 0x%04X",uErrCode);
		return rgcUnk;
	}
	return rgszErrs[uErrCode & 0xff];
}


/* Telnet states */

#define TS_DATA	0	/* normal data */
#define TS_IAC	1
#define TS_WILL	2
#define TS_WONT	3
#define TS_DO	4
#define TS_DONT	5
#define TS_SB	6
#define TS_WSE	7
#define TS_TT	8
#define TS_3270	9

/* Telnet commands */
#define	TN_IAC	255	/* Interpret as command */
#define	TN_SE	240
#define	TN_SB	250
#define	TN_WILL	251
#define	TN_WONT	252
#define	TN_DO	253
#define	TN_DONT	254

/* Telnet subnegotiation */

#define TN_IS			0
#define TN_ARE			1
#define TN_SEND			1

/* Telnet options */
#define	TN_TRANSMIT_BINARY	0
#define	TN_ECHO				1
#define	TN_RCP				2
#define	TN_SUPPRESS_GA		3
#define	TN_NAMS				4
#define	TN_STATUS			5
#define	TN_TIMING_MARK		6
#define	TN_RCTE				7
#define	TN_NAOL				8	/* Negotiate about o/p line width */
#define	TN_NAOP				9	/* Negotiate about o/p page size */
#define	TN_NAOCRD			10	/* Negotiate about o/p CR dispos */
#define	TN_NAOHTS			11	/* Negotiate about o/p hor tab stops */
#define	TN_NAOHTD			12	/* Negotiate about o/p hor tab disp */
#define	TN_NAOFFD			13	/* Negotiate about o/p FF disp */
#define	TN_NAOVTS			14	/* Negotiate about vertical tabstops */
#define	TN_NAOVTD			15	/* Negotiate about vertical tab disp */
#define	TN_NAOLFD			16	/* Negotiate about o/p LF disp */
#define	TN_EXTEND_ASCII		17
#define	TN_LOGOUT			18
#define	TN_BM				19
#define	TN_DET				20
#define	TN_SUPDUP			21
#define	TN_SUPDUP_OUTPUT 	22
#define	TN_SEND_LOCATION 	23
#define	TN_TERMINAL_TYPE 	24
#define	TN_END_OF_RECORD 	25
#define	TN_TUID				26
#define	TN_OUTMRK			27
#define	TN_3270_REGIME		29
#define	TN_NAWS				31
#define	TN_TERMINAL_SPEED	32
#define	TN_TOGGLE_FLOW_CONTROL 33
#define	TN_LINEMODE			34
#define	TN_EXOPL			255
#define TN_TN3270E			40
#define TN_IMPLEMENTED		29	/* highest number implemented */

/* implemented options */

#define	TNI_TRANSMIT_BINARY	0
#define	TNI_ECHO			1
#define	TNI_SUPPRESS_GA		2
#define	TNI_TERMINAL_TYPE	3
#define	TNI_END_OF_RECORD	4
#define	TNI_3270_REGIME		5
#define	TNI_NAWS			6
#define	TNI_TERMINAL_SPEED	7
#define	TNI_TOGGLE_FLOW_CONTROL	8
#define	TNI_LINEMODE		9
#define TNI_TN3270E			10
#define TNI_SEND_LOCATION	11
#define	NOPTIONS			12


char rgcTelnetOptions[TN_IMPLEMENTED + 1] =
{	/* implemented options */
	TNI_TRANSMIT_BINARY,/* TN_TRANSMIT_BINARY */
	TNI_ECHO,			/* TN_ECHO */
	NOPTIONS,			/* TN_RCP */
	TNI_SUPPRESS_GA,	/* TN_SUPPRESS_GA */
	NOPTIONS,			/* TN_NAMS */
	NOPTIONS,			/* TN_STATUS */
	NOPTIONS,			/* TN_TIMING_MARK */
	NOPTIONS,			/* TN_RCTE */
	NOPTIONS,			/* TN_NAOL */
	NOPTIONS,			/* TN_NAOP */
	NOPTIONS,			/* TN_NAOCRD */
	NOPTIONS,			/* TN_NAOHTS */
	NOPTIONS,			/* TN_NAOHTD */
	NOPTIONS,			/* TN_NAOFFD */
	NOPTIONS,			/* TN_NAOVTS */
	NOPTIONS,			/* TN_NAOVTD */
	NOPTIONS,			/* TN_NAOLFD */
	NOPTIONS,			/* TN_EXTEND_ASCII */
	NOPTIONS,			/* TN_LOGOUT */
	NOPTIONS,			/* TN_BM */
	NOPTIONS,			/* TN_DET */
	NOPTIONS,			/* TN_SUPDUP */
	NOPTIONS,			/* TN_SUPDUP_OUTPUT */
	NOPTIONS,			/* TN_SEND_LOCATION */
	TNI_TERMINAL_TYPE,	/* TN_TERMINAL_TYPE */
	TNI_END_OF_RECORD,	/* TN_END_OF_RECORD */
	NOPTIONS,			/* TN_TUID */
	NOPTIONS,			/* TN_OUTMRK */
	NOPTIONS,			/* ????????? */
	TNI_3270_REGIME,	/* TN_3270_REGIME */
};

char rgcLocal[NOPTIONS];
char rgcRemote[NOPTIONS];
char cDontSent;		//allready sent dont for specified option, dont send again
char cWontSent;      //same as above

#define TO_NOSET  0x80	/* WONT a DO request and DONT a WILL request */
#define TO_SENT	  0x40	/* option already sent */
#define TO_TTRCVD 0x20	/* Terminal type has been received */
#define TO_INIT	  0x10	/* Initialize negotiation on invokation of client */
#define TO_SET	  0x01	/* DO or WILL is set */

static BYTE rgbSubEnd[] = {TN_IAC,TN_SE};
static BYTE rgbSubBegin[] = {TN_IAC,TN_SB,TN_TERMINAL_TYPE,TN_IS};
static BYTE rgbTermType[] = "dumb";

/*
Initiate telnet. Our negotionation preferences may be set here.

This function currently does nothing.
*/
void InitTelnet(void)
{
//	rgcLocal[TNI_TERMINAL_TYPE] |= TO_NOSET;
}

/*
Strip and handle Telnet options. The data in the buffer is compressed to
contain only ordinary (non-telnet) data bytes. The length of the compressed
data is returned.

Arguments:
	pcBuf - Pointer to buffer containing telnet data to handle
	iCnt - Count of octets to handle

Returns:
	The amount of normal data bytes remaining in the buffer.
*/
int TeloptStrip(char *pcBuf,int iCnt)
{
	int iRetCnt;
	char *pcReadPos;
	char *pcWritePos;
	BYTE bCh;

	/* Optimization for very common special case -- no TNOPT */
	if (iTelnetState == TS_DATA && memchr(pcBuf,TN_IAC,iCnt) == NULL)
	{
		return iCnt;
	}
	pcWritePos = pcReadPos = pcBuf;
	iRetCnt = 0;

	while (iCnt--)
	{
		bCh = *pcReadPos++;
		switch(iTelnetState)
		{
		case TS_DATA:
			if (bCh == TN_IAC)
			{
				iTelnetState = TS_IAC;
			}
			else
			{
				*pcWritePos++ = bCh;
				++iRetCnt;
			}
			break;
		case TS_IAC:
			switch (bCh)
			{
			case TN_WILL:
				iTelnetState = TS_WILL;
				break;
			case TN_WONT:
				iTelnetState = TS_WONT;
				break;
			case TN_DO:
				iTelnetState = TS_DO;
				break;
			case TN_DONT:
				iTelnetState = TS_DONT;
				break;
			case TN_IAC:
				*pcWritePos++ = bCh;
				++iRetCnt;
				iTelnetState = TS_DATA;
				break;
			case TN_SB:
				iTelnetState = TS_SB;
				break;
			default:
				iTelnetState = TS_DATA;
				break;
			}
			break;
		case TS_WILL:
			WillOpt(bCh);
			iTelnetState = TS_DATA;
			break;
		case TS_WONT:
			WontOpt(bCh);
			iTelnetState = TS_DATA;
			break;
		case TS_DO:
			DoOpt(bCh);
			iTelnetState = TS_DATA;
			break;
		case TS_DONT:
			DontOpt(bCh);
			iTelnetState = TS_DATA;
			break;
		case TS_SB:
			if (bCh == TN_IAC)
				iTelnetState = TS_IAC;
			else if (bCh == TN_3270_REGIME)
				iTelnetState = TS_3270;
			else if (bCh == TN_TERMINAL_TYPE)
				iTelnetState = TS_TT;
			else
				iTelnetState = TS_WSE;
			break;
		case TS_3270:
			if (bCh == TN_IAC)
				iTelnetState = TS_IAC;
//			else
//				r3270(bCh);
			break;
		case TS_WSE:		/* ignore up to next IAC */
			if (bCh == TN_IAC)
				iTelnetState = TS_IAC;
			break;
		case TS_TT:
			if (bCh == TN_SEND)
			{
				char *p;
				int len;
				char nbuf[50];

				memcpy(nbuf,rgbSubBegin,sizeof(rgbSubBegin));
				strcpy(nbuf + (len = sizeof(rgbSubBegin)),
						p = rgbTermType);
				memcpy(nbuf + (len += strlen(p)),rgbSubEnd,
								sizeof(rgbSubEnd));
				SendData(nbuf,len + sizeof(rgbSubEnd));
			}
			else if (bCh == TN_IS)
				rgcRemote[TNI_TERMINAL_TYPE] |= TO_TTRCVD;
			iTelnetState = TS_WSE;
			break;
		}
	}
	return iRetCnt;
}

/*
Handle a 'will' sent by the other party by replying on it based on the
preferences in the rgcRemote array.

Argument:
	cOption - The option to be negotiated.
*/
void WillOpt(char cOption)
{
	BYTE bAck = TN_DONT;
	int iOptionIndex = rgcTelnetOptions[cOption];
	char *pcOption;
//	static char asktt[] = {TN_IAC,SB,TN_TERMINAL_TYPE,TN_SEND,TN_IAC,TN_SE,0};

	if (cOption <= TN_IMPLEMENTED && iOptionIndex < NOPTIONS)
	{
		pcOption = rgcRemote + iOptionIndex;
		if (*pcOption & (TO_SET | TO_SENT))
		{
			/* Already set or sent, ignore to prevent loop */
			*pcOption = (*pcOption & ~TO_SENT) | TO_SET;
			if (!(*pcOption & TO_NOSET))
				bAck = TN_DO;
			goto testtt;
		}
		if (!(*pcOption & TO_NOSET))
		{
			*pcOption |= TO_SET;
			bAck = TN_DO;
		}
	}
	else if (cOption == cDontSent)
		return;		/* have already sent a DONT for this one */
	else
		cDontSent = cOption;
	SendOpt(bAck,cOption);
	testtt:
//	if (cOption == TN_TERMINAL_TYPE && bAck == DO) {
//		sndmsg(asktt);
//	}
	if (cOption == TN_3270_REGIME && (rgcLocal[TNI_3270_REGIME] & TO_SET) &&
				(rgcRemote[TNI_3270_REGIME] & TO_SET))
	{
		Send3270Regime();
	}
}

/*
Handle a 'wont' sent by the other party by replying on it based on the
preferences in the rgcRemote array.

Argument:
	cOption - The option to be negotiated.
*/
void WontOpt(char cOption)
{
	int iOptionIndex = rgcTelnetOptions[cOption];
	char *pcOption;
	char oldopt;

	if (cOption <= TN_IMPLEMENTED && iOptionIndex < NOPTIONS)
	{
		oldopt = *(pcOption = rgcRemote + iOptionIndex);
		*pcOption &= ~(TO_SET | TO_SENT);
		if ((oldopt & (TO_SENT | TO_SET)) == TO_SENT)
		{
			/* Already clear, ignore to prevent loop */
			return;
		}
	}
	else if (cOption == cDontSent)
		return;		/* have already sent a DONT for this one */
	else
		cDontSent = cOption;
	SendOpt(TN_DONT,cOption);	/* Must always accept */
}

/*
Handle a 'do' sent by the other party by replying on it based on the
preferences in the rgcLocal array.

Argument:
	cOption - The option to be negotiated.
*/
void DoOpt(char cOption)
{
	BYTE bAck = TN_WONT;
	int iOptionIndex = rgcTelnetOptions[cOption];
	char *pcOption;

	if (cOption <= TN_IMPLEMENTED && iOptionIndex < NOPTIONS)
	{
		pcOption = rgcLocal + iOptionIndex;
		if (*pcOption & (TO_SET | TO_SENT))
		{
			/* Already set or sent, ignore to prevent loop */
			*pcOption = (*pcOption & ~TO_SENT) | TO_SET;
			goto check3270;
		}
		if (!(*pcOption & TO_NOSET))
		{
			*pcOption |= TO_SET;
			bAck = TN_WILL;
		}
	}
	else if (cOption == cWontSent)
		return;		/* have already sent a WONT for this one */
	else
		cWontSent = cOption;
	SendOpt(bAck,cOption);
	check3270:
	if (cOption == TN_3270_REGIME && (rgcLocal[TNI_3270_REGIME] & TO_SET) &&
				(rgcRemote[TNI_3270_REGIME] & TO_SET))
	{
		Send3270Regime();
	}
}

/*
Handle a 'dont' sent by the other party by replying on it based on the
preferences in the rgcLocal array.

Argument:
	cOption - The option to be negotiated.
*/
void DontOpt(char cOption)
{
	int iOptionIndex = rgcTelnetOptions[cOption];
	char *pcOption,oldopt;

	if (cOption <= TN_IMPLEMENTED && iOptionIndex < NOPTIONS)
	{
		oldopt = *(pcOption = rgcLocal + iOptionIndex);
		*pcOption &= ~(TO_SET | TO_SENT);
		if ((oldopt & (TO_SENT | TO_SET)) == TO_SENT)
		{
			/* Already clear, ignore to prevent loop */
			return;
		}
	}
	else if (cOption == cWontSent)
		return;		/* have already sent a WONT for this one */
	else
		cWontSent = cOption;
	SendOpt(TN_WONT,cOption);
}

/*
Send a telnet sub-negotiation containing the terminal type of this terminal.
(Needed for some terminal servers)
*/
void Send3270Regime()
{
	int iOffset;
	static BYTE rgbSubFirst[] = {TN_IAC,TN_SB,TN_3270_REGIME,TN_ARE};
	char rgcBuf[60];

	memcpy(rgcBuf, rgbSubFirst, sizeof(rgbSubFirst));
	iOffset = sizeof(rgbSubFirst);
	strcpy(rgcBuf + iOffset, rgbTermType);
	iOffset += strlen(rgbTermType);
	memcpy(rgcBuf + iOffset, rgbSubEnd, sizeof(rgbSubEnd));
	SendData(rgcBuf, iOffset + sizeof(rgbSubEnd));
}

/*
Send a telnet command to the server for the specified option.

arguments:
	cCommand - The Telnet command (will, wont, etc)
	cOption - The telnet option (eg echo)
*/
void SendOpt(BYTE cCommand, BYTE cOption)
{
	BYTE rgbSend[3];
	int iOptionIndex;

	if ((iOptionIndex = rgcTelnetOptions[cOption]) < NOPTIONS)
	{
		//record that we sent this command to prevent loop.
		*(((cCommand == TN_WILL || cCommand == TN_WONT) ? rgcLocal : rgcRemote)
		 +	iOptionIndex) |= TO_SENT;
	}
	rgbSend[0] = TN_IAC;
	rgbSend[1] = cCommand;
	rgbSend[2] = cOption;
	SendData(rgbSend, 3);
}
